﻿'ماژول نمایش تاریخ شمسی
Module persian
    Public Function PersianDate(Optional ByVal InDate As Date = Nothing) As String
        Try
            If InDate.Year <= 1 Then InDate = Now
            Dim PClndr As New Globalization.PersianCalendar
            Dim DateInIran As String = PClndr.GetYear(InDate)
            DateInIran &= "/" & Strings.Right(("0" & PClndr.GetMonth(InDate)), 2)
            DateInIran &= "/" & Strings.Right(("0" & PClndr.GetDayOfMonth(InDate)), 2)
            Return DateInIran
        Catch ex As Exception
            Return ""
        End Try
    End Function

    Public Function PersianDateString(Optional ByVal InDate As Date = Nothing, Optional ByVal ShowDayWeek As Boolean = False) As String
        Try
            If InDate.Year <= 1 Then InDate = Now
            Dim PClndr As New Globalization.PersianCalendar
            Dim DateInIran As String = PClndr.GetYear(InDate)
            DateInIran &= "/" & Strings.Right(("0" & PClndr.GetMonth(InDate)), 2)
            DateInIran &= "/" & Strings.Right(("0" & PClndr.GetDayOfMonth(InDate)), 2)

            Dim DT() As String = Split(DateInIran + " ", "/")

            DateInIran = ""

            If ShowDayWeek = True Then
                Select Case PClndr.GetDayOfWeek(InDate)
                    Case "1"
                        DateInIran = "دوشنبه "
                    Case "2"
                        DateInIran = "سه شنبه "
                    Case "3"
                        DateInIran = "چهارشنبه "
                    Case "4"
                        DateInIran = "پنج شنبه "
                    Case "5"
                        DateInIran = "جمعه "
                    Case "6"
                        DateInIran = "شنبه "
                    Case "0"
                        DateInIran = "يکشنبه "
                End Select
            End If

            DateInIran &= DT(2)

            Select Case DT(1)
                Case "01"
                    DateInIran &= "فروردين"
                Case "02"
                    DateInIran &= "ارديبهشت"
                Case "03"
                    DateInIran &= "خرداد"
                Case "04"
                    DateInIran &= "تير"
                Case "05"
                    DateInIran &= "مرداد"
                Case "06"
                    DateInIran &= "شهريور"
                Case "07"
                    DateInIran &= "مهر"
                Case "08"
                    DateInIran &= "آبان"
                Case "09"
                    DateInIran &= "آذر"
                Case "10"
                    DateInIran &= "دي"
                Case "11"
                    DateInIran &= "بهمن"
                Case "12"
                    DateInIran &= "اسفند"
            End Select

            DateInIran &= " ماه " & DT(0)

            Return DateInIran
        Catch ex As Exception
            Return ""
        End Try
    End Function
End Module
