var $ = jQuery;

// Make sure the DOM elements are loaded and accounted for
$(document).ready(function () {
  'use strict';

  // Search button click
  $(document).on("click", ".base_theme", function (e) {
    var selTheme = $(this).val();

    var foreColor, neonColor;
    switch (selTheme) {
      case 'azure':
        foreColor = '#9af3fd';
        neonColor = '#3550b1';
        break;
      case 'red':
        foreColor = '#fd7e7e';
        neonColor = '#900505';
        break;
      case 'green':
        foreColor = '#32ff1c';
        neonColor = '#157b25';
        break;
      case 'purple':
        foreColor = '#ff71f4';
        neonColor = '#8a1198';
        break;
      case 'yellow':
        foreColor = '#f3fd55';
        neonColor = '#906a01';
        break;
      case 'white':
        foreColor = '#ffffff';
        neonColor = '#777777';
        break;
      case 'blue':
        foreColor = '#5a5ef5';
        neonColor = '#1b2a65';
        break;
      case 'orange':
        foreColor = '#ff8822';
        neonColor = '#964703';
        break;
      default:
    }

    $('.vc_active')
      .find('.border_left_color').val(foreColor).trigger('change').end()
      .find('.border_right_color').val(foreColor).trigger('change').end()
      .find('.border_top_color').val(foreColor).trigger('change').end()
      .find('.border_bottom_color').val(foreColor).trigger('change').end()

      .find('.border_left_neon_color').val(neonColor).trigger('change').end()
      .find('.border_right_neon_color').val(neonColor).trigger('change').end()
      .find('.border_top_neon_color').val(neonColor).trigger('change').end()
      .find('.border_bottom_neon_color').val(neonColor).trigger('change').end()

      .find('.icon_color').val(foreColor).trigger('change').end()      
      .find('.icon_neon_color').val(neonColor).trigger('change').end()

      .find('.text_font_color').val(foreColor).trigger('change').end()
      .find('.text_neon_color').val(neonColor).trigger('change').end()
      ;

    return false;
  });

});