<?php

/**
 * Adds new shortcode "zim_neon_box" and registers it to
 * the WPBakery Visual Composer plugin
 *
 */


// If this file is called directly, abort
if (!defined('ABSPATH')) {
  wp_die(__('Hi there!  I\'m just a plugin, not much I can do when called directly.'));
}


if (function_exists('vc_map')) {

	class NeonBox
	{


		/**
		 * Main constructor
		 *
		 */
		public function __construct()
		{

			// Registers the shortcode in WordPress
			add_shortcode('zim_neon_box', array('NeonBox', 'output_neon_box'));

			// Map shortcode to Visual Composer
			if (function_exists('vc_lean_map')) {
				vc_lean_map('zim_neon_box', array('NeonBox', 'map_neon_box'));
			}
		}


		/**
		 * Map shortcode to VC
		 *
		 * This is an array of all your settings which become the shortcode attributes ($atts)
		 * for the output.
		 *
		 */
		public static function map_neon_box()
		{
			return array(
				'name'        => esc_html__('Neon Box', 'vc-neon-box'),
				'description' => esc_html__('Neon Effects', 'vc-neon-box'),
				'base'        => 'vc_infobox',
				'category' => esc_html__('ZIM Modules', 'vc-neon-box'),
				'icon' => 'zim_neon_box',
				'params'      => array(
					// Theme
					array(
						'type' => 'dropdown',
						'heading' => esc_html__('Base Theme', 'vc-neon-box'),
						'param_name' => 'base_theme',
						'value' => array(
							esc_html__('Azure', 'vc-neon-box') => 'azure',
							esc_html__('Green', 'vc-neon-box')   => 'green',
							esc_html__('Purple', 'vc-neon-box')  => 'purple',
							esc_html__('Yellow', 'vc-neon-box')   => 'yellow',
							esc_html__('Red', 'vc-neon-box') => 'red',
							esc_html__('White', 'vc-neon-box')   => 'white',
							esc_html__('Blue', 'vc-neon-box') => 'blue',
							esc_html__('Orange', 'vc-neon-box') => 'orange',
						),
						'std' => 'azure',
						'edit_field_class' => 'vc_col-sm-6',
					),

					// -- Content
					array(
						'type' => 'textarea',
						'heading' => esc_html__('Text', 'vc-neon-box'),
						'param_name' => 'text',
						'value' => 'قلم فارسی زیبا برای ویژوال کامپوزر',
						'admin_label' => true,
					),
					// -- Tag
					array(
						'type' => 'dropdown',
						'heading' => esc_html__('Text Tag', 'vc-neon-box'),
						'param_name' => 'text_tag',
						'value' => array(
							esc_html__('Span', 'vc-neon-box') => 'span',
							esc_html__('Div', 'vc-neon-box')  => 'div',
							esc_html__('H2', 'vc-neon-box')   => 'h2',
							esc_html__('H3', 'vc-neon-box')   => 'h3',
							esc_html__('H4', 'vc-neon-box')   => 'h4',
							esc_html__('H5', 'vc-neon-box')   => 'h5',
							esc_html__('H6', 'vc-neon-box')   => 'h6',
						),
						'std' => 'div',
						'edit_field_class' => 'vc_col-sm-6',
					),
					
					// -- Align
					array(
						'type' => 'dropdown',
						'heading' => esc_html__('Text Alignment', 'vc-neon-box'),
						'param_name' => 'text_align',
						'value' => array(
							esc_html__('Right', 'vc-neon-box')  => 'right',
							esc_html__('Center', 'vc-neon-box') => 'center',
							esc_html__('Left', 'vc-neon-box')   => 'left',
						),
						'edit_field_class' => 'vc_col-sm-6',
					),
					// -- Font
					array(
						'type' => 'dropdown',
						'heading' => esc_html__('Font Family', 'vc-neon-box'),
						'param_name' => 'text_font',
						'value' => array(
							esc_html__('Far Homa', 'vc-neon-box') 				=> 'Far_Homa',
							esc_html__('Far Kamran', 'vc-neon-box')  		=> 'Far_Kamran',
							esc_html__('Far KoodkBd', 'vc-neon-box')   	=> 'Far_KoodkBd',
							esc_html__('Far Mitra', 'vc-neon-box')   		=> 'Far_Mitra',
							esc_html__('Far Nastaliq', 'vc-neon-box')  	=> 'Far_Nastaliq',
							esc_html__('Far Nazanin', 'vc-neon-box')   	=> 'Far_Nazanin',
							esc_html__('Far TitrBd', 'vc-neon-box')   		=> 'Far_TitrBd',
							esc_html__('Far Yekan', 'vc-neon-box') 			=> 'Far_Yekan',
							esc_html__('Far Zar', 'vc-neon-box')  				=> 'Far_Zar',
							esc_html__('ADastNevis', 'vc-neon-box')   		=> 'ADastNevis',
							esc_html__('Vazir Regular', 'vc-neon-box') 	=> 'Vazir-Regular',
							esc_html__('Arial', 'vc-neon-box')   				=> 'Arial',
							esc_html__('Calibri', 'vc-neon-box')   			=> 'Calibri',
							esc_html__('Courier New', 'vc-neon-box')   	=> 'Courier New',
							esc_html__('Segoe UI', 'vc-neon-box')   			=> 'Segoe UI',
							esc_html__('Tahoma', 'vc-neon-box')   				=> 'Tahoma',
							esc_html__('Times New Roman', 'vc-neon-box') => 'Times New Roman',
						),
						
						
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__('Font Size', 'vc-neon-box'),
						'param_name' => 'text_font_size',
						'value' => '70',
						'description' => esc_html__('Enter Font Size in pixels.', 'vc-neon-box'),
						'edit_field_class' => 'vc_col-sm-4',
					),
					array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Font Color', 'vc-neon-box'),
						'param_name' => 'text_font_color',
						'value' => '#9af3fd',
						'description' => esc_html__('Set Font Color.', 'vc-neon-box'),
						'edit_field_class' => 'vc_col-sm-8',
					),
					// -- Neon
					array(
						'type' => 'textfield',
						'heading' => esc_html__('Neon Size', 'vc-neon-box'),
						'param_name' => 'text_neon_size',
						'value' => '5',
						'edit_field_class' => 'vc_col-sm-4',
					),
					array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Neon Color', 'vc-neon-box'),
						'param_name' => 'text_neon_color',
						'value' => '#3550b1',
						'edit_field_class' => 'vc_col-sm-8',
					),

					// Style
					// -- Background Color
					array(
						'type' => 'checkbox',
						'heading' => esc_html__('Custom Background Color', 'vc-neon-box'),
						'param_name' => 'custom_bg_color',
						'value' => array('بله'   => 'true' ),
						'std' => 'true',
						'save_always' => true,
						'group' => esc_html__('Style'),
						'edit_field_class' => 'vc_col-sm-4',
					),
					array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Background Color', 'vc-neon-box'),
						'param_name' => 'bg_color',
						'group' => esc_html__('Style'),
						'value' => '#000000',
						'save_always' => true,
						'dependency' => array(
							'element' => 'custom_bg_color',
							'value' => 'true'
						),
						'edit_field_class' => 'vc_col-sm-4',
						'description' => esc_html__('Choose color for Background.', 'vc-neon-box'),
					),
					// -- Border Left
					array(
						'type' => 'checkbox',
						'heading' => esc_html__('Border Left', 'vc-neon-box'),
						'param_name' => 'border_left',
						'group' => esc_html__('Style'),
						'edit_field_class' => 'vc_col-sm-12',
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__('Border Size','vc-neon-box'),
						'param_name' => 'border_left_size',
						'value' => '2',
						'description' => esc_html__('Enter Border Size in pixels.', 'vc-neon-box'),
						'group' => esc_html__('Style'),
						'dependency' => array(
							'element' => 'border_left',
							'value' => 'true'
						),
						'edit_field_class' => 'vc_col-sm-2',
					),
					array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Border Color', 'vc-neon-box'),
						'param_name' => 'border_left_color',
						'group' => esc_html__('Style'),
						'value' => '#9af3fd',
						'save_always' => true,
						'dependency' => array(
							'element' => 'border_left',
							'value' => 'true'
						),
						'edit_field_class' => 'vc_col-sm-4',
						'description' => esc_html__('Choose color for Border Left.', 'vc-neon-box'),
					),
					array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Neon Color', 'vc-neon-box'),
						'param_name' => 'border_left_neon_color',
						'group' => esc_html__('Style'),
						'value' => '#3550b1',
						'save_always' => true,
						'dependency' => array(
							'element' => 'border_left',
							'value' => 'true'
						),
						'edit_field_class' => 'vc_col-sm-4',
						'description' => esc_html__('Choose color for Border Left.', 'vc-neon-box'),
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__('Neon Size','vc-neon-box'),
						'param_name' => 'border_left_neon_size',
						'value' => '10',
						'description' => esc_html__('Enter Neon Size in pixels.', 'vc-neon-box'),
						'group' => esc_html__('Style'),
						'dependency' => array(
							'element' => 'border_left',
							'value' => 'true'
						),
						'edit_field_class' => 'vc_col-sm-2',
					),
					// -- Border Right
					array(
						'type' => 'checkbox',
						'heading' => esc_html__('Border Right', 'vc-neon-box'),
						'param_name' => 'border_right',
						'group' => esc_html__('Style'),
						'edit_field_class' => 'vc_col-sm-12',
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__('Border Size', 'vc-neon-box'),
						'param_name' => 'border_right_size',
						'value' => '2',
						'description' => esc_html__('Enter Border Size in pixels.', 'vc-neon-box'),
						'group' => esc_html__('Style'),
						'dependency' => array(
							'element' => 'border_right',
							'value' => 'true'
						),
						'edit_field_class' => 'vc_col-sm-2',
					),
					array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Border Color', 'vc-neon-box'),
						'param_name' => 'border_right_color',
						'group' => esc_html__('Style'),
						'value' => '#9af3fd',
						'save_always' => true,
						'dependency' => array(
							'element' => 'border_right',
							'value' => 'true'
						),
						'edit_field_class' => 'vc_col-sm-4',
						'description' => esc_html__('Choose color for Border Right.', 'vc-neon-box'),
					),
					array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Neon Color', 'vc-neon-box'),
						'param_name' => 'border_right_neon_color',
						'group' => esc_html__('Style'),
						'value' => '#3550b1',
						'save_always' => true,
						'dependency' => array(
							'element' => 'border_right',
							'value' => 'true'
						),
						'edit_field_class' => 'vc_col-sm-4',
						'description' => esc_html__('Choose color for Border Right.', 'vc-neon-box'),
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__('Neon Size','vc-neon-box'),
						'param_name' => 'border_right_neon_size',
						'value' => '10',
						'description' => esc_html__('Enter Neon Size in pixels.', 'vc-neon-box'),
						'group' => esc_html__('Style'),
						'dependency' => array(
							'element' => 'border_right',
							'value' => 'true'
						),
						'edit_field_class' => 'vc_col-sm-2',
					),
					// -- Border Top
					array(
						'type' => 'checkbox',
						'heading' => esc_html__('Border Top', 'vc-neon-box'),
						'param_name' => 'border_top',
						'group' => esc_html__('Style'),
						'edit_field_class' => 'vc_col-sm-12',
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__('Border Size', 'vc-neon-box'),
						'param_name' => 'border_top_size',
						'value' => '2',
						'description' => esc_html__('Enter Border Size in pixels.', 'vc-neon-box'),
						'group' => esc_html__('Style'),
						'dependency' => array(
							'element' => 'border_top',
							'value' => 'true'
						),
						'edit_field_class' => 'vc_col-sm-2',
					),
					array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Border Color', 'vc-neon-box'),
						'param_name' => 'border_top_color',
						'group' => esc_html__('Style'),
						'value' => '#9af3fd',
						'save_always' => true,
						'dependency' => array(
							'element' => 'border_top',
							'value' => 'true'
						),
						'edit_field_class' => 'vc_col-sm-4',
						'description' => esc_html__('Choose color for Border Top.', 'vc-neon-box'),
					),
					array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Neon Color', 'vc-neon-box'),
						'param_name' => 'border_top_neon_color',
						'group' => esc_html__('Style'),
						'value' => '#3550b1',
						'save_always' => true,
						'dependency' => array(
							'element' => 'border_top',
							'value' => 'true'
						),
						'edit_field_class' => 'vc_col-sm-4',
						'description' => esc_html__('Choose color for Border Top.', 'vc-neon-box'),
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__('Neon Size', 'vc-neon-box'),
						'param_name' => 'border_top_neon_size',
						'value' => '10',
						'description' => esc_html__('Enter Neon Size in pixels.', 'vc-neon-box'),
						'group' => esc_html__('Style'),
						'dependency' => array(
							'element' => 'border_top',
							'value' => 'true'
						),
						'edit_field_class' => 'vc_col-sm-2',
					),
					// -- Border Bottom
					array(
						'type' => 'checkbox',
						'heading' => esc_html__('Border Bottom', 'vc-neon-box'),
						'param_name' => 'border_bottom',
						'group' => esc_html__('Style'),
						'edit_field_class' => 'vc_col-sm-12',
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__('Border Size', 'vc-neon-box'),
						'param_name' => 'border_bottom_size',
						'value' => '2',
						'description' => esc_html__('Enter Border Size in pixels.', 'vc-neon-box'),
						'group' => esc_html__('Style'),
						'dependency' => array(
							'element' => 'border_bottom',
							'value' => 'true'
						),
						'edit_field_class' => 'vc_col-sm-2',
					),
					array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Border Color', 'vc-neon-box'),
						'param_name' => 'border_bottom_color',
						'group' => esc_html__('Style'),
						'value' => '#9af3fd',
						'save_always' => true,
						'dependency' => array(
							'element' => 'border_bottom',
							'value' => 'true'
						),
						'edit_field_class' => 'vc_col-sm-4',
						'description' => esc_html__('Choose color for Border Bottom.', 'vc-neon-box'),
					),
					array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Neon Color', 'vc-neon-box'),
						'param_name' => 'border_bottom_neon_color',
						'group' => esc_html__('Style'),
						'value' => '#3550b1',
						'save_always' => true,
						'dependency' => array(
							'element' => 'border_bottom',
							'value' => 'true'
						),
						'edit_field_class' => 'vc_col-sm-4',
						'description' => esc_html__('Choose color for Border Bottom.', 'vc-neon-box'),
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__('Neon Size', 'vc-neon-box'),
						'param_name' => 'border_bottom_neon_size',
						'value' => '10',
						'description' => esc_html__('Enter Neon Size in pixels.', 'vc-neon-box'),
						'group' => esc_html__('Style'),
						'dependency' => array(
							'element' => 'border_bottom',
							'value' => 'true'
						),
						'edit_field_class' => 'vc_col-sm-2',
					),
					// -- Box Shadow
					array(
						'type' => 'checkbox',
						'heading' => esc_html__('Box Shadow', 'vc-neon-box'),
						'param_name' => 'box_shadow',
						'group' => esc_html__('Style'),
						'edit_field_class' => 'vc_col-sm-4',
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__('Box Shadow Size', 'vc-neon-box'),
						'param_name' => 'box_shadow_size',
						'value' => '10',
						'description' => esc_html__('Enter Box Shadow Size in pixels.', 'vc-neon-box'),
						'group' => esc_html__('Style'),
						'dependency' => array(
							'element' => 'box_shadow',
							'value' => 'true'
						),
						'edit_field_class' => 'vc_col-sm-4',
					),
					array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Box Shadow Color', 'vc-neon-box'),
						'param_name' => 'box_shadow_color',
						'group' => esc_html__('Style'),
						'value' => '',
						'save_always' => true,
						'dependency' => array(
							'element' => 'box_shadow',
							'value' => 'true'
						),
						'edit_field_class' => 'vc_col-sm-4',
						'description' => esc_html__('Choose color for Box Shadow.', 'vc-neon-box'),
					),
					// Box Padding
					array(
						'type' => 'checkbox',
						'heading' => esc_html__('Custom Padding Content', 'vc-neon-box'),
						'param_name' => 'custom_padding',
						'group' => esc_html__('Style'),
						'edit_field_class' => 'vc_col-sm-12',
					),
					// -- Pading Left
					array(
						'type' => 'textfield',
						'heading' => esc_html__('Padding Left','vc-neon-box'),
						'param_name' => 'box_pad_left',
						'value' => '5',
						'group' => esc_html__('Style'),
						'dependency' => array(
							'element' => 'custom_padding',
							'value' => 'true'
						),
						'edit_field_class' => 'vc_col-sm-3',
					),
					// -- Pading Right
					array(
						'type' => 'textfield',
						'heading' => esc_html__('Padding Right','vc-neon-box'),
						'param_name' => 'box_pad_right',
						'value' => '5',
						'group' => esc_html__('Style'),
						'dependency' => array(
							'element' => 'custom_padding',
							'value' => 'true'
						),
						'edit_field_class' => 'vc_col-sm-3',
					),
					// -- Pading Top
					array(
						'type' => 'textfield',
						'heading' => esc_html__('Padding Top','vc-neon-box'),
						'param_name' => 'box_pad_top',
						'value' => '5',
						'group' => esc_html__('Style'),
						'dependency' => array(
							'element' => 'custom_padding',
							'value' => 'true'
						),
						'edit_field_class' => 'vc_col-sm-3',
					),
					// -- Pading Bottom
					array(
						'type' => 'textfield',
						'heading' => esc_html__('Padding Bottom','vc-neon-box'),
						'param_name' => 'box_pad_bottom',
						'value' => '5',
						'group' => esc_html__('Style'),
						'dependency' => array(
							'element' => 'custom_padding',
							'value' => 'true'
						),
						'edit_field_class' => 'vc_col-sm-3',
					),

				
					// Neon Animation
					array(
						'type' => 'dropdown',
						'heading' => esc_html__('Neon Animation', 'vc-neon-box'),
						'param_name' => 'neon_animation',
						'value' => array(
							esc_html__('None', 'vc-neon-box')   => 'none',
							esc_html__('Blink', 'vc-neon-box')   => 'blink',
							esc_html__('Shake', 'vc-neon-box') => 'shake',
							esc_html__('Wiggle', 'vc-neon-box')  => 'wiggle',
						),
						'std' => '',
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__('Animation Duration', 'vc-neon-box'),
						'param_name' => 'neon_animation_time',
						'value' => '',
						'description' => esc_html__('Enter animation duration time in seconds. (Leave blank for default)', 'vc-neon-box'),
						'edit_field_class' => 'vc_col-sm-6',
					),

					// CSS Animation
					//vc_map_add_css_animation(false),
					array(
						'type' => 'textfield',
						'heading' => esc_html__('Extra Class', 'vc-neon-box'),
						'param_name' => 'extra_class',
						'group' => esc_html__('Style'),
						'description' => esc_html__('Add an extra class name to the element and refer to it from Custom CSS option.', 'vc-neon-box')
					),

				),
			);
		}


		/**
		 * Shortcode output
		 *
		 */
		public static function output_neon_box($atts, $content = null)
		{

			extract(
				shortcode_atts(
					array(
						// General
						'neon_animation' => '',
						'neon_animation_time' => '',
						'extra_class' => '',
						'animation_class' => '',
						// Content
						'text' => 'قلم فارسی زیبا برای ویژوال کامپوزر',
						'text_tag' => 'div',
						'text_align' => 'right',
						'text_font' => 'Far_Mitra',
						'text_font_size' => '70',
						'text_font_color' => '#9af3fd',
						'text_neon_size' => '2',
						'text_neon_color' => '#3550b1',
						// Borders
						'border_left' => false,
						'border_left_size' => '2',
						'border_left_color' => '#9af3fd',
						'border_left_neon_color' => '#3550b1',
						'border_left_neon_size' => '7',
						'border_right' => false,
						'border_right_size' => '2',
						'border_right_color' => '#9af3fd',
						'border_right_neon_color' => '#3550b1',
						'border_right_neon_size' => '7',
						'border_top' => false,
						'border_top_size' => '2',
						'border_top_color' => '#9af3fd',
						'border_top_neon_color' => '#3550b1',
						'border_top_neon_size' => '7',
						'border_bottom' => false,
						'border_bottom_size' => '2',
						'border_bottom_color' => '#9af3fd',
						'border_bottom_neon_color' => '#3550b1',
						'border_bottom_neon_size' => '7',
						// box
						'box_shadow' => false,
						'box_shadow_size' => '0',
						'box_shadow_color' => '',
						'custom_bg_color' => 'true',
						'bg_color' => '#000000',
						'custom_padding' => false,
						'box_pad_left' => '10',
						'box_pad_right' => '10',
						'box_pad_top' => '10',
						'box_pad_bottom' => '10',
						
					),
					$atts
				)
			);

			// div
			$box_shadow_style = 'box-shadow: 0 0 10px ' . (int) $box_shadow_size . 'px ' . esc_html($box_shadow_color) . '; ';
			$div_style = ($custom_bg_color ? 'background-color: ' . esc_html($bg_color) . '; ' : '');
			$div_style .= ($box_shadow ? $box_shadow_style . '-webkit-' . $box_shadow_style  . '-moz-' . $box_shadow_style : '');
			// div class
			// -- animation
			$div_class = $animation_class;
			// borders
			// -- border left
			$bl_neon_style = 'box-shadow: 0 0 10px ' . (int) $border_left_neon_size / 2 . 'px ' . esc_html($border_left_neon_color) . '; ';
			$bl_style = 'border: ' . (int) $border_left_size . 'px solid ' . esc_html($border_left_color) . '; ';
			$bl_style .= ($border_left_neon_size ? $bl_neon_style . '-webkit-' . $bl_neon_style  . '-moz-' . $bl_neon_style : '');
			$bl_html = ($border_left ? '<i class="neonbox_border_left" style="' . $bl_style . '"></i>' : '');
			// -- border right
			$br_neon_style = 'box-shadow: 0 0 10px ' . (int) $border_right_neon_size / 2 . 'px ' . esc_html($border_right_neon_color) . '; ';
			$br_style = 'border: ' . (int) $border_right_size . 'px solid ' . esc_html($border_right_color) . '; ';
			$br_style .= ($border_right_neon_size ? $br_neon_style . '-webkit-' . $br_neon_style  . '-moz-' . $br_neon_style : '');
			$br_html = ($border_right ? '<i class="neonbox_border_right" style="' . $br_style . '"></i>' : '');
			// -- border top
			$bt_neon_style = 'box-shadow: 0 0 10px ' . (int) $border_top_neon_size / 2 . 'px ' . esc_html($border_top_neon_color) . '; ';
			$bt_style = 'border: ' . (int) $border_top_size . 'px solid ' . esc_html($border_top_color) . '; ';
			$bt_style .= ($border_top_neon_size ? $bt_neon_style . '-webkit-' . $bt_neon_style  . '-moz-' . $bt_neon_style : '');
			$bt_html = ($border_top ? '<i class="neonbox_border_top" style="' . $bt_style . '"></i>' : '');
			// -- border bottom
			$bb_neon_style = 'box-shadow: 0 0 10px ' . (int) $border_bottom_neon_size / 2 . 'px ' . esc_html($border_bottom_neon_color) . '; ';
			$bb_style = 'border: ' . (int) $border_bottom_size . 'px solid ' . esc_html($border_bottom_color) . '; ';
			$bb_style .= ($border_bottom_neon_size ? $bb_neon_style . '-webkit-' . $bb_neon_style  . '-moz-' . $bb_neon_style : '');
			$bb_html = ($border_bottom ? '<i class="neonbox_border_bottom" style="' . $bb_style . '"></i>' : '');
			
			// content
			$text_tag = esc_attr($text_tag);

			$text_class = ($neon_animation != 'none' ? 'vcnb_' . esc_attr($neon_animation) : '');
			$text_style = ($text_font_size != '' ? 'font-size: ' . (int) $text_font_size . 'px; ' : '');
			$text_style .= ($text_font_color != '' ? 'color: ' . esc_html($text_font_color) . '; ' : '');
			$text_style .= ((int) $neon_animation_time > 0 ? 'animation-duration: ' . (int) $neon_animation_time . 's; ' : '');

			$text_neon_size = (int) $text_neon_size;
			$dbl_text_neon_size = 2 * $text_neon_size;
			$text_neon_style = 'text-shadow: ' . $text_neon_size . 'px ' . $text_neon_size . 'px ' . $dbl_text_neon_size . 'px ' . esc_html($text_neon_color) . ',' .
				-$text_neon_size . 'px ' . $text_neon_size . 'px ' . $dbl_text_neon_size . 'px ' . esc_html($text_neon_color) . ',' .
				$text_neon_size . 'px ' . -$text_neon_size . 'px ' . $dbl_text_neon_size . 'px ' . esc_html($text_neon_color) . ',' .
				-$text_neon_size . 'px ' . -$text_neon_size . 'px ' . $dbl_text_neon_size . 'px ' . esc_html($text_neon_color) . ';';

			$text_style .= $text_neon_style;

			//******************//
			// MANAGE FONT DATA //
			//******************//
			// Build the data array
			//$text_font_data = self::getFontsData($text_font);
			// Build the inline style
			//$text_font_inline_style = self::googleFontsStyles($text_font_data);
			// Enqueue the right font   
			//self::enqueueGoogleFonts($text_font_data);

			$content .=
				'<' . $text_tag . ' class="neonbox_text a' . esc_attr($text_align) . ' ' . esc_attr($text_class) . 
				'" style="font-family: \'' . esc_attr($text_font) . '\'; ' . $text_style . ';" >' .
				wp_kses_post($text) .
				'</' . $text_tag . '>';


			$content_style = ($custom_padding ? 'padding-left: ' . (int) $box_pad_left . 'px; ' : '');
			$content_style .= ($custom_padding ? 'padding-right: ' . (int) $box_pad_right . 'px; ' : '');
			$content_style .= ($custom_padding ? 'padding-top: ' . (int) $box_pad_top . 'px; ' : '');
			$content_style .= ($custom_padding ? 'padding-bottom: ' . (int) $box_pad_bottom . 'px; ' : '');

			// Fill $html var with data
			$html = '
				<div class="neonbox_container ' . esc_attr($div_class) . ' ' . esc_attr($extra_class) . '" style="' . $div_style . '">' .
				$bl_html . $bt_html .
				'<div class="neonbox_content" style="' . $content_style . '">' . 
				($icon_type == 'font' ? $icon_html : '') .
				($icon_type == 'image' ? $img_html : '') .
				$content . 
				'</div>' .
				$br_html . $bb_html . '
        </div>';

			return $html;
		}
	
	}
}
new NeonBox;
