<?php

/*
Plugin Name: VC Neon Box
Text Domain:vc-neon-box
Plugin URI: https://anysoft.ir/neonbox/
Description:Persian Fonts with Neon Effects for WPBakery Page Builder
Author: anysoft
Version: 1.0.1
Author URI: https://www.anysoft.ir/
*/


// If this file is called directly, abort
if (!defined('ABSPATH')) {
  wp_die(__('Hi there!  I\'m just a plugin, not much I can do when called directly.'));
}

// Check Visual Composer is activated
add_action('admin_init', 'vcnb_vc_is_activated');
function vcnb_vc_is_activated()
{
  if (is_admin() && current_user_can('activate_plugins') &&  !is_plugin_active('js_composer/js_composer.php')) {
    add_action('admin_notices', 'vcnb_vc_plugin_notice');

    deactivate_plugins(plugin_basename(__FILE__));

    if (isset($_GET['activate'])) {
      unset($_GET['activate']);
    }
  }
}
// Show plugin notice
function vcnb_vc_plugin_notice()
{
  echo '<div class="error">
          <p>'. esc_html__('Sorry, The "VC Neon Box" plugin requires the "WPBakery Page Builder" plugin to be installed and active.', 'vc-neon-box') . '</p>
        </div>';
}

// Before VC Init
add_action('vc_before_init', 'vcnb_before_init');
function vcnb_before_init()
{
  $inc_path = plugin_dir_path(__FILE__) . 'includes/';

  // Require new custom Element
  include($inc_path . 'neon-box.php');
}

// Front Scripts
add_action('wp_enqueue_scripts', 'vcnb_front_scripts');
function vcnb_front_scripts()
{
  wp_enqueue_style('vcnb-stylesheet', plugin_dir_url(__FILE__) . 'assets/css/style.css');
  wp_enqueue_style('vcnb-fonts', plugin_dir_url(__FILE__) . 'assets/css/font.css');
}

// Admin Scripts
add_action('admin_enqueue_scripts', 'vcnb_back_scripts');
function vcnb_back_scripts()
{
  wp_enqueue_style('vcnb-admin-css', plugin_dir_url(__FILE__) . 'assets/css/admin.css');
  wp_enqueue_script('vcnb-admin-script', plugin_dir_url(__FILE__) . 'assets/js/admin.js', array('jquery'), '', true);
}
 function vcnb_translate_plugin_init() {
  load_plugin_textdomain('vc-neon-box', false, basename( dirname( __FILE__ ) ) . '/languages' );
}
add_action('init', 'vcnb_translate_plugin_init');
